
Type TBallLauncher
	Field _direction:Vector2 = Vector2.Zero()
	Field _speed:Float
	Field _boxtexture:TImage
	Field _ballTexture:TImage
	Field _ballRadius:Int = 15
	Field _boxWidth:Int = 50
	Field _boxHeight:Int = 50
	Field _physics:TPhysicsSimulator
	Field _position:Vector2 = Vector2.Zero()
	Field _balls:TList = CreateList()
	Field _elapsedTime:Float
	Field _createInterval:Float = 2
	Field _body:TBody
	Field _geom:TGeom
	
	Function Create:TBallLauncher(physics:TPhysicsSimulator, position:Vector2, shootDirection:Vector2, shootSpeed:Float)
		Local launcher:TBallLauncher = New TBallLauncher
		launcher._position.Set(position)
		launcher._direction.Set(shootDirection)
		launcher._direction.Normalize()
		launcher._speed = shootSpeed
		launcher._physics = physics
		launcher.Load(physics)
		Return launcher
	End Function
	
	
	Method Load(physics:TPhysicsSimulator)
		_boxTexture = TDrawingHelper.CreateRectangleTexture(_boxWidth, _boxHeight, TColor.White, TColor.Black)
		MidHandleImage(_boxTexture)
		_body = TBodyFactory.CreateRectangleBody(_physics, _boxWidth, _boxHeight, 1)
		_geom = TGeomFactory.CreateRectangleGeom(_physics, _body, _boxWidth, _boxHeight)
		_body.SetStatic(True)
		_body.SetPosition(_position)
		_geom.SetCollisionCategory(CollisionCategories.Cat5)
		_geom.SetCollidesWith(CollisionCategories.All & ~ CollisionCategories.Cat4)
	End Method
	
	Method Draw()
		For Local b:TPhysBall = EachIn _balls
			b.Draw()
		Next
		TDrawingHelper.DrawGeom(_geom, _boxTexture)
	End Method
	
	Method Update()
		_elapsedTime:+.016
		If _elapsedTime > _createInterval Then
			_elapsedTime = 0
			Local vel:Vector2 = _direction.Copy()
			vel.Scale(_speed)
			_balls.AddLast(TPhysBall.Create(_physics, _ballRadius, _position, vel))
		End If
		For Local b:TPhysBall = EachIn _balls
			b.Update()
			If b._timeLeft <= 0 Then
				_balls.Remove(b)
			End If
		Next
	End Method
End Type

Private
Type TPhysBall
	Global _texture:TImage
	Field _radius:Int
	Field _body:TBody
	Field _geom:TGeom
	Field _initialVel:Vector2 = Vector2.Zero()
	Field _intialPos:Vector2 = Vector2.Zero()
	Field _timeLeft:Float = 10
	Field _physics:TPhysicsSimulator
	Function Create:TPhysBall(physics:TPhysicsSimulator, radius:Int, position:Vector2, velocity:Vector2)
		Local b:TPhysBall = New TPhysBall
		b._initialVel.Set(velocity)
		b._radius = radius
		b._intialPos.Set(position)
		b.Load(physics)
		b._physics = physics
		Return b
	End Function
	
	Method Load(physics:TPhysicsSimulator)
		If _texture = Null Then
			_texture = TDrawingHelper.CreateCircleTexture(_radius, TColor.Black, TColor.White)
			MidHandleImage(_texture)
		End If
		_body = TBodyFactory.CreateCircleBody(physics, _radius, 1)
		_geom = TGeomFactory.CreateCircleGeom(physics, _body, _radius, 10)
		_geom.SetCollidesWith(CollisionCategories.All & ~CollisionCategories.Cat5)
		_geom.SetCollisionCategory(CollisionCategories.cat4)
		_body.SetPosition(_intialPos)
		_body.SetLinearVelocity(_initialVel)
	End Method
	
	Method Update()
		_timeLeft:-.016
		If _timeLeft <= 0 Then
			_physics.RemoveBody(_body)
			_physics.RemoveGeom(_geom)
		End If
	End Method
	
	Method Draw()
		TDrawingHelper.DrawGeom(_geom, _texture)
	End Method
End Type
Public
